/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.projectile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.slf4j.Logger;

public class EffectCloudBaseEntity
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.m_135353_(EffectCloudBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(EffectCloudBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.m_135353_(EffectCloudBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.m_135353_(EffectCloudBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private Potion potion = Potions.f_43598_;
    private final List<MobEffectInstance> effects = Lists.newArrayList();
    protected final Map<Entity, Integer> victims = Maps.newHashMap();
    private boolean isStarting = false;
    private int duration = 600;
    protected int lifeTicks = 0;
    private int waitTime = 20;
    protected int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public EffectCloudBaseEntity(EntityType<? extends EffectCloudBaseEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public EffectCloudBaseEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends EffectCloudBaseEntity>)((EntityType)ImmortalersDelightEntities.BASE_EFFECT_CLOUD.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DANGEROUS, (Object)false);
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        this.m_20088_().m_135372_(DATA_WAITING, (Object)false);
        this.m_20088_().m_135372_(DATA_PARTICLE, (Object)ParticleTypes.f_123811_);
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANGEROUS);
    }

    public void setDangerous(boolean pInvulnerable) {
        this.f_19804_.m_135381_(DATA_DANGEROUS, (Object)pInvulnerable);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float pRadius) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)pRadius, (float)0.0f, (float)7.995f)));
        }
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void setPotion(Potion pPotion) {
        this.potion = pPotion;
    }

    public void addEffect(MobEffectInstance pEffectInstance) {
        this.effects.add(pEffectInstance);
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.m_20088_().m_135370_(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions pParticleOption) {
        this.m_20088_().m_135381_(DATA_PARTICLE, (Object)pParticleOption);
    }

    protected void setWaiting(boolean pWaiting) {
        this.m_20088_().m_135381_(DATA_WAITING, (Object)pWaiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int pDuration) {
        this.duration = pDuration;
    }

    protected void updateParticles(float f) {
        float f1;
        int i;
        boolean flag = this.isWaiting();
        if (flag && this.f_19796_.m_188499_()) {
            return;
        }
        ParticleOptions particleoptions = this.getParticle();
        if (flag) {
            i = 2;
            f1 = 0.2f;
        } else {
            i = Mth.m_14167_((float)((float)Math.PI * f * f));
            f1 = f;
        }
        for (int j = 0; j < i; ++j) {
            double d7;
            double d6;
            double d5;
            float f2 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            float f3 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f1;
            double d0 = this.m_20185_() + (double)(Mth.m_14089_((float)f2) * f3);
            double d2 = this.m_20186_() + (this.f_19796_.m_188499_() ? 0.5 : -0.5) * (double)f3;
            double d4 = this.m_20189_() + (double)(Mth.m_14031_((float)f2) * f3);
            if (flag) {
                d5 = 0.0;
                d6 = 0.0;
                d7 = 0.0;
            } else {
                d5 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                d6 = 0.01f;
                d7 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
            }
            this.m_9236_().m_7107_(particleoptions, d0, d2, d4, d5, d6, d7);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        boolean flag = this.isWaiting();
        float f = this.getRadius();
        if (this.m_9236_().f_46443_) {
            ++this.lifeTicks;
            this.updateParticles(f);
        } else {
            boolean flag1;
            if (this.f_19797_ >= this.waitTime + this.duration) {
                this.m_146870_();
                return;
            }
            boolean bl = flag1 = this.f_19797_ < this.waitTime;
            if (flag != flag1) {
                this.isStarting = true;
                this.setWaiting(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.isStarting) {
                this.doOnStart(f);
                this.isStarting = false;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.m_146870_();
                    return;
                }
                this.setRadius(f);
            }
            this.doOnPersist(f);
        }
    }

    public void doOnStart(float range) {
    }

    public void doOnPersist(float range) {
        float f = range;
        if (this.f_19797_ % 5 == 0) {
            this.victims.entrySet().removeIf(p_287380_ -> this.f_19797_ >= (Integer)p_287380_.getValue());
            boolean flag1 = this.addAreaEffect(f);
            boolean flag2 = this.doAdditionalAction(f);
            if (flag1 || flag2) {
                if (this.radiusOnUse != 0.0f) {
                    if ((f += this.radiusOnUse) < 0.5f) {
                        this.m_146870_();
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.durationOnUse != 0) {
                    this.duration += this.durationOnUse;
                    if (this.duration <= 0) {
                        this.m_146870_();
                        return;
                    }
                }
            }
        }
    }

    protected boolean addAreaEffect(float range) {
        List<MobEffectInstance> list = this.getAllEffects();
        if (list.isEmpty()) {
            return false;
        }
        List list1 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
        if (!list1.isEmpty()) {
            boolean flag = false;
            for (LivingEntity livingentity : list1) {
                double d1;
                double d8;
                double d3;
                LivingEntity caster = this.getOwner();
                if (!livingentity.m_6084_() || this.victims.containsKey(livingentity) || livingentity == caster || caster != null && (caster.m_7307_((Entity)livingentity) || livingentity.m_7307_((Entity)caster)) || !((d3 = (d8 = livingentity.m_20185_() - this.m_20185_()) * d8 + (d1 = livingentity.m_20189_() - this.m_20189_()) * d1) <= (double)(range * range))) continue;
                this.victims.put((Entity)livingentity, this.f_19797_ + this.reapplicationDelay);
                this.doOnAddEffect(livingentity, list);
                flag = true;
            }
            return flag;
        }
        return false;
    }

    public List<MobEffectInstance> getAllEffects() {
        ArrayList list = Lists.newArrayList();
        for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
            list.add(new MobEffectInstance(mobeffectinstance.m_19544_(), mobeffectinstance.m_267696_(p_267926_ -> p_267926_ / 4), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()));
        }
        list.addAll(this.effects);
        return list;
    }

    protected void doOnAddEffect(LivingEntity livingentity, List<MobEffectInstance> list) {
        for (MobEffectInstance mobeffectinstance1 : list) {
            if (mobeffectinstance1.m_19544_().m_8093_()) {
                mobeffectinstance1.m_19544_().m_19461_((Entity)this, (Entity)this.getOwner(), livingentity, mobeffectinstance1.m_19564_(), 0.5);
                continue;
            }
            livingentity.m_147207_(new MobEffectInstance(mobeffectinstance1), (Entity)this);
        }
    }

    protected boolean doAdditionalAction(float range) {
        return false;
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float pRadiusOnUse) {
        this.radiusOnUse = pRadiusOnUse;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float pRadiusPerTick) {
        this.radiusPerTick = pRadiusPerTick;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int pDurationOnUse) {
        this.durationOnUse = pDurationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int pWaitTime) {
        this.waitTime = pWaitTime;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.f_19797_ = pCompound.m_128451_("Age");
        this.duration = pCompound.m_128451_("Duration");
        this.waitTime = pCompound.m_128451_("WaitTime");
        this.reapplicationDelay = pCompound.m_128451_("ReapplicationDelay");
        this.durationOnUse = pCompound.m_128451_("DurationOnUse");
        this.radiusOnUse = pCompound.m_128457_("RadiusOnUse");
        this.radiusPerTick = pCompound.m_128457_("RadiusPerTick");
        this.setRadius(pCompound.m_128457_("Radius"));
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
        if (pCompound.m_128425_("Particle", 8)) {
            try {
                this.setParticle(ParticleArgument.m_247456_((StringReader)new StringReader(pCompound.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)pCompound.m_128461_("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (pCompound.m_128425_("Potion", 8)) {
            this.setPotion(PotionUtils.m_43577_((CompoundTag)pCompound));
        }
        if (pCompound.m_128425_("Effects", 9)) {
            ListTag listtag = pCompound.m_128437_("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < listtag.size(); ++i) {
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)listtag.m_128728_(i));
                if (mobeffectinstance == null) continue;
                this.addEffect(mobeffectinstance);
            }
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Age", this.f_19797_);
        pCompound.m_128405_("Duration", this.duration);
        pCompound.m_128405_("WaitTime", this.waitTime);
        pCompound.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        pCompound.m_128405_("DurationOnUse", this.durationOnUse);
        pCompound.m_128350_("RadiusOnUse", this.radiusOnUse);
        pCompound.m_128350_("RadiusPerTick", this.radiusPerTick);
        pCompound.m_128350_("Radius", this.getRadius());
        pCompound.m_128359_("Particle", this.getParticle().m_5942_());
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        if (this.potion != Potions.f_43598_) {
            pCompound.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            pCompound.m_128365_("Effects", (Tag)listtag);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_RADIUS.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public Potion getPotion() {
        return this.potion;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 0.5f));
    }

    public float getAnimationProgress(float pPartialTicks) {
        int i = this.waitTime - this.lifeTicks;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - pPartialTicks) / (float)this.waitTime;
    }
}

